;
;************************
;    DEMO DIP SWITCH    *
;     EXPERIMENT 0      *
;************************
;
         CPU  "8085.TBL"
         HOF  "INT8"
;
         ORG  2100H
BUF:     EQU  3000H
SEG:     EQU  0B9H
LED:     EQU  0BAH
DELAY:   EQU  0FH
SYSCAL:  EQU  2
DIP:     EQU  0A0H
;
;***********************
;     SET PARAMETER    *
;***********************
;
INIT:    MVI  A,80H               ;Control port
         OUT  0BBH
         MVI  C,05EH              ;segment display D
         MOV  E,C                 ;toggle display
         IN   DIP                 ;read dipsw8 save to buf
         STA  BUF
;
LOOP:    MOV  A,C                 ;display
         OUT  SEG
         MVI  A,DELAY
         MVI  B,80H
         RST  SYSCAL
;
         IN   DIP                 ;read new bit of dip8
         STA  BUF+1
         MOV  B,A                 ;save new bit to b
         LDA  BUF                 ;load old bit
         CMP  B                   ;compare old & new bit
         JZ   LOOP1
;
;/* dipsw cange find bit change */

         MVI  D,0                 ;start bit
CHK_0:   MOV  L,A
         ANI  1
         MOV  H,A
         MOV  A,B
         ANI  1
         CMP  H
         JNZ  CHK_1               ;bit not equ goto chk_1

         INR  D                   ;next bit compare
         MOV  A,B
         RRC
         MOV  B,A
         MOV  A,L
         RRC
         JMP  CHK_0
;
;/* bit change */
;
CHK_1:   ORI  0FEH                ;bit not change = 1
         LXI  H,TAB_SEG           ;find segment position bit
         MOV  C,D
         MVI  B,0
         DAD  B
         MOV  C,M
         MOV  E,M

         MOV  B,A
         MOV  A,D
         CPI  0
         MOV  A,B
         JZ   CHK_3               ;bit change = bit 0 goto chk_3
;
;/* get position bit */
;
CHK_2:   RLC
         DCR  D
         JNZ  CHK_2
;
CHK_3:   MOV  D,A
         LDA  BUF+1
         ANA  D
         CMA
;
;/* save bit */

         MVI  D,8
CHK_4:   RRC
         DCR  D
         JNZ  CHK_4

         OUT  LED
         LDA  BUF+1
         STA  BUF

;/* toggle segment */
;
LOOP1:   MOV  A,E                 ;data toggle
         XRA  C                   ;data on segment
         MOV  C,A
         JMP  LOOP
;
;/* data segment 1-8 */

TAB_SEG: DFB  7FH,07H,7DH,6DH
         DFB  66H,4FH,5BH,06H
         END
;
